/*
 Copyright 2015 SpinalCom - www.spinalcom.com
*
* This file is part of SpinalCore.
*
* Please read all of the following terms and conditions
* of the Free Software license Agreement ("Agreement")
* carefully.
*
* This Agreement is a legally binding contract between
* the Licensee (as defined below) and SpinalCom that
* sets forth the terms and conditions that govern your
* use of the Program. By installing and/or using the
* Program, you agree to abide by all the terms and
* conditions stated or referenced herein.
*
* If you do not agree to abide by these terms and
* conditions, do not demonstrate your acceptance and do
* not install or use the Program.
*
* You should have received a copy of the license along
* with this file. If not, see
* <http://resources.spinalcom.com/licenses.pdf>.
*/

#include "../Sys/BinOut.h"
#include "Path.h"

Path::Path( QString _data ) : _data( _data ) {
}

void Path::write_str( QDebug dbg ) const {
    // ModelWithAttr::write_str( dbg );
    dbg.nospace() << _data;
}

Path::operator QString() const {
    return _data;
}

QString Path::type() const {
    return "Path";
}

bool Path::_set( const char *str, int len ) {
    QString tmp = QString::fromUtf8( str, len );
    bool res = _data != tmp;
    _data = tmp;
    return res;
}

void Path::write_usr( BinOut &nut, BinOut &uut, Database *db ) {
    uut << 'W' << get_server_id( db ) << _data;
}
